/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed Materials - Property of IBM                                               
* Tivoli Presentation Services                                   
*                                                    
* (C) Copyright IBM Corp. 2004  All Rights Reserved.
*                                                               
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
************************************************************ {COPYRIGHT-END} ***
* Change Activity on 2/19/04 version 1.9:
*******************************************************************************/



/**
 * Static, Singleton Constructor
 */
if ( !self.WOverview )
{
    self.WOverview = new WOverviewImpl();
}
function WOverviewImpl()
{
    this.init           = WOverview_init;
    this.grab           = WOverview_grab;
    this.drag           = WOverview_drag;
    this.drop           = WOverview_drop;

    this.callback       = WOverview_callback;
}

function WOverview_init( e, viewportId, overviewId, overviewImageUrl, lassoDivId )
{
    var wEvent = new WEvent( e );
    var overview = document.getElementById( overviewId );
    var viewport = document.getElementById( viewportId );
    var lassoDiv = document.getElementById( lassoDivId );
    viewport.overviewId = overviewId;
    overview.overviewImageUrl = overviewImageUrl;
    overview.lassoDivId = lassoDivId;
    overview.viewportId = viewportId;

    overview.isLoading = false;

    lassoDiv.onmousedown = new Function( "e", "WOverview.grab( e, '" + overviewId + "');" );
    lassoDiv.onmousemove = new Function( "e", "WOverview.drag( e, '" + overviewId + "');" );
    overview.onmousemove = new Function( "e", "WOverview.drag( e, '" + overviewId + "');" );
    lassoDiv.onmouseup = new Function( "e", "WOverview.drop( e, '" + overviewId + "');" );
    lassoDiv.onselectstart = new Function ( "e", "return false;" );
    overview.onselectstart = new Function ( "e", "return false;" );

    // setup resize listener
    WUtilities.addResizeCallback( overviewId, new Function( "e", "WOverview_handleWindowResize(e,'" + overviewId + "');return true;" ) );

    // initialize lasso by invoking callback
    if ( viewport.callbacks != null )
    {
        WOverview.callback( overview.viewportId );
    }
}

function WOverview_handleWindowResize( e, overviewId )
{
    var overview = document.getElementById( overviewId );
    WOverview.callback( overview.viewportId );

}

function WOverview_grab( e, overviewId )
{
    var wEvent = new WEvent( e );
    var overview = document.getElementById( overviewId );
    var lasso = document.getElementById( overview.lassoDivId );

    if ( !lasso.mouseDown )
    {
        var lassoLeft = WUtilities.getLeft( lasso, true );
        var lassoTop = WUtilities.getTop( lasso, true );
        lasso.startPosition = new Position( lassoLeft, lassoTop );
        lasso.startMousePosition = lasso.currentMousePosition = wEvent.getPagePosition();
        lasso.mouseDown = true;
    }
}

function WOverview_drag( e, overviewId )
{
    var wEvent = new WEvent( e );
    var overview = document.getElementById( overviewId );
    var lasso = document.getElementById( overview.lassoDivId );

    if ( lasso.mouseDown )
    {
        lasso.currentMousePosition = wEvent.getPagePosition();

        var overviewX = WUtilities.getLeft( overview, true );
        var overviewY = WUtilities.getTop( overview, true );
        var overviewWidth = WUtilities.getWidth( overview );
        var overviewHeight = WUtilities.getHeight( overview );

        var diffX = lasso.startMousePosition.getX() - lasso.startPosition.getX();
        var diffY = lasso.startMousePosition.getY() - lasso.startPosition.getY();

        var lassoX = lasso.currentMousePosition.getX() - diffX;
        var lassoY = lasso.currentMousePosition.getY() - diffY;
        var lassoWidth = parseInt( lasso.style.width );
        var lassoHeight = parseInt( lasso.style.height );

        if ( lassoX >= overviewX  && (lassoX+lassoWidth) <= (overviewX+overviewWidth) )
        {
            lasso.style.left = lassoX + "px";
        }
        if ( lassoY >= overviewY  && (lassoY+lassoHeight) <= (overviewY+overviewHeight) )
        {
            lasso.style.top = lassoY + "px";
        }
    }
}

function WOverview_drop( e, overviewId )
{
    var wEvent = new WEvent( e );
    var overview = document.getElementById( overviewId );
    var lasso = document.getElementById( overview.lassoDivId );

    if ( lasso.mouseDown )
    {
        lasso.mouseDown = false;
        lasso.currentMousePosition = wEvent.getPagePosition();

        var diffX = lasso.currentMousePosition.getX() - lasso.startMousePosition.getX();
        var diffY = lasso.currentMousePosition.getY() - lasso.startMousePosition.getY();

        if ( diffX != 0 || diffY != 0 )
        {
            var viewport = document.getElementById( overview.viewportId );
            var worldRect = WImageViewport.getWorldRectangle( overview.viewportId );
            
            var overviewWidth = WUtilities.getWidth( overview );
            var overviewHeight = WUtilities.getHeight( overview );

            var xFactor = overviewWidth / worldRect.getWidth();
            var yFactor = overviewHeight / worldRect.getHeight();

            var panX = Math.round( diffX / xFactor );
            var panY = Math.round( diffY / yFactor );

            WImageViewport.pan( viewport.id, panX, panY );
        }
    }
}

function WOverview_callback( viewportId )
{
    var viewport = document.getElementById( viewportId );
    var overview = document.getElementById( viewport.overviewId );
    if ( !overview || !overview.lassoDivId )
    {
        setTimeout( 'WOverview.callback("' + viewportId + '")', 100 ); 
    }
    else
    {
        var lasso = document.getElementById( overview.lassoDivId );
        if ( !lasso )
        {
            setTimeout( 'WOverview.callback("' + viewportId + '")', 100 ); 
        }
        else
        {
            var viewRect = WImageViewport.getViewRectangle( viewportId );
            var worldRect = WImageViewport.getWorldRectangle( viewportId );

            var overviewTop = WUtilities.getTop( overview, true );
            var overviewLeft = WUtilities.getLeft( overview, true );
            var overviewWidth = WUtilities.getWidth( overview );
            var overviewHeight = WUtilities.getHeight( overview );

            var lassoTop = parseInt( lasso.style.top );
            var lassoLeft = parseInt( lasso.style.left );

            var xFactor = overviewWidth / worldRect.getWidth();
            var yFactor = overviewHeight / worldRect.getHeight();

            var lassoWidth = Math.round( xFactor * viewRect.getWidth() );
            var lassoHeight = Math.round( yFactor * viewRect.getHeight() );

            var viewX = Math.round( xFactor * viewRect.getX() );
            var viewY = Math.round( yFactor * viewRect.getY() );
            
            lassoTop = overviewTop + viewY;
            lassoLeft = overviewLeft + viewX;
            
            // check bounds
            if ( lassoTop < overviewTop )
            {
                lassoTop = overviewTop;
            }
            if ( lassoLeft < overviewLeft )
            {
                lassoLeft = overviewLeft;
            }
            if ( lassoTop+lassoHeight > overviewTop+overviewHeight )
            {
                lassoHeight = overviewHeight - (lassoTop-overviewTop);
            }
            if ( lassoLeft+lassoWidth > overviewLeft+overviewWidth )
            {
                lassoWidth = overviewWidth - (lassoLeft-overviewLeft);
            }
            
            with ( lasso.style )
            {
                top = lassoTop + "px";
                left = lassoLeft + "px";
                width = lassoWidth + "px";
                height = lassoHeight + "px";
                visibility = "visible";
            }
        }
    }
}
